*** Table 4:  NAACP Chapters and CORE Demonstrations

cd "$path"
global data "$path/data/"
global output "$path/results"

estimates clear 


*** OPEN MAIN COUNTY DTA 
use  "$data/main_county_FD.dta", clear

foreach t in 40 50 60 {
	
gen fr_black_40_y`t'=fr_black_40*y_`t'
gen cong_dem_40_y`t'=cong_dem_40*y_`t'
gen dem_40_y`t'=dem_40*y_`t'

}


egen cst=group(statefip county)
egen stateyear=group(statefip year)
egen regionyear=group(region year)

xtset cst year, delta(10)
global controls fr_black_40_y* dem_40_y*


*********************************************************************

cd "$output"

// Panel A 


* NAACP 
reg D6040_NAACP D6040_fr_black dem_40 fr_black_40 i.statefip [aw=totpop_40]  if year==1940 , cl(cst)
      su D6040_NAACP [aw=totpop_40] if e(sample)
      local mout=round(r(mean), .001)
      su D6040_fr_black [aw=totpop_40] if e(sample)
      local mtr=round(r(mean), .001)
      su D6040_fr_black [aw=totpop_40] if e(sample)
      local sdtr=round(r(sd), .001)
outreg2 using Table4_A.xls, excel nocon replace ///
keep (D6040_fr_black)  dec(3) addtext(NAACP 1940, NO, Avg. outcome,`mout',Avg. treatment,`mtr',S.d. treatment,`sdtr')


ivreg2 D6040_NAACP (D6040_fr_black=Z_40to60_p40) dem_40 fr_black_40 i.statefip  [aw=totpop_40] if year==1940  , cl(cst) ffirst savefirst 
local F=e(widstat)
      su D6040_NAACP [aw=totpop_40] if e(sample)
      local mout=round(r(mean), .001)
      su D6040_fr_black [aw=totpop_40] if e(sample)
      local mtr=round(r(mean), .001)
      su D6040_fr_black [aw=totpop_40] if e(sample)
      local sdtr=round(r(sd), .001)
outreg2 using Table4_A.xls, excel nocon append ///
keep (D6040_fr_black)  dec(3) ctitle("2SLS") addstat( "F-stat", `F') addtext(NAACP 1940, YES, Avg. outcome,`mout',Avg. treatment,`mtr',S.d. treatment,`sdtr')

est restore _ivreg2_D6040_fr_black
outreg2 using Table4_B.xls, excel nocon replace ///
keep (Z_40to60_p40)  dec(3)



ivreg2 D6040_NAACP (D6040_fr_black=Z_40to60_p40) dem_40 fr_black_40 i.statefip [aw=totpop_40]  if year==1940 & NAACP40==0  , cl(cst) ffirst savefirst 
local F=e(widstat)
      su D6040_NAACP [aw=totpop_40] if e(sample)
      local mout=round(r(mean), .001)
      su D6040_fr_black [aw=totpop_40] if e(sample)
      local mtr=round(r(mean), .001)
      su D6040_fr_black [aw=totpop_40] if e(sample)
      local sdtr=round(r(sd), .001)
outreg2 using Table4_A.xls, excel nocon append ///
keep (D6040_fr_black)  dec(3) ctitle("2SLS") addstat( "F-stat", `F') addtext(NAACP 1940, NO, Avg. outcome,`mout',Avg. treatment,`mtr',S.d. treatment,`sdtr')

est restore _ivreg2_D6040_fr_black
outreg2 using Table4_B.xls, excel nocon append ///
keep (Z_40to60_p40)  dec(3)



* CORE 
reg D_dummy_protest  D_fr_black $controls  i.stateyear [aw=totpop_40] , cl(cst)
      su D_dummy_protest [aw=totpop_40] if e(sample)
      local mout=round(r(mean), .001)
      su D_fr_black [aw=totpop_40] if e(sample)
      local mtr=round(r(mean), .001)
      su D_fr_black [aw=totpop_40] if e(sample)
      local sdtr=round(r(sd), .001)
outreg2 using Table4_A.xls, excel nocon append ///
keep (D_fr_black)  dec(3)  ctitle("Dummy")  addtext(Black share 40, X, Dem 40, X, White Participants, ., Avg. outcome,`mout',Avg. treatment,`mtr',S.d. treatment,`sdtr') 


ivreg2 D_dummy_protest (D_fr_black=Z_p40) $controls i.stateyear [aw=totpop_40] , cl(cst) ffirst savefirst 
local F=e(widstat)
      su D_dummy_protest [aw=totpop_40] if e(sample)
      local mout=round(r(mean), .001)
      su D_fr_black [aw=totpop_40] if e(sample)
      local mtr=round(r(mean), .001)
      su D_fr_black [aw=totpop_40] if e(sample)
      local sdtr=round(r(sd), .001)
outreg2 using Table4_A.xls, excel nocon append ///
keep (D_fr_black)  dec(3) ctitle("Dummy") addstat( "F-stat", `F') addtext(Black share 40, X, Dem 40, X, White Participants, ., Avg. outcome,`mout',Avg. treatment,`mtr',S.d. treatment,`sdtr')

est restore _ivreg2_D_fr_black
outreg2 using Table4_B.xls, excel nocon append ///
keep (Z_p40)  dec(3)



ivreg2 D_dummy_white_protest (D_fr_black=Z_p40)  $controls i.stateyear [aw=totpop_40], cl(cst) ffirst savefirst 
local F=e(widstat)
      su D_dummy_white_protest [aw=totpop_40] if e(sample)
      local mout=round(r(mean), .001)
      su D_fr_black [aw=totpop_40] if e(sample)
      local mtr=round(r(mean), .001)
      su D_fr_black [aw=totpop_40] if e(sample)
      local sdtr=round(r(sd), .001)
outreg2 using Table4_A.xls, excel nocon append ///
keep (D_fr_black)  dec(3) ctitle("Dummy") addstat( "F-stat", `F') addtext(Black share 40, X, Dem 40, X, White Participants, X, Avg. outcome,`mout',Avg. treatment,`mtr',S.d. treatment,`sdtr')

est restore _ivreg2_D_fr_black
outreg2 using Table4_B.xls, excel nocon append ///
keep (Z_p40)  dec(3)

